clear all
clc
close all
% Define Cell Parameters
Q = 2*3600; %2Ah capacity
Ct = 2700; %Double layer capacitance
Rt = 0.011; %SEI layer Charge transfer resistance
Rs = 0.008; %Cell internal resistance
Rd = 1e6; %Self-discharge resistor
SOC_0=0.5; %Initial SOC

% Controller Parameters
Kp=2;
Ki=0.8;
Imax=2*Q/3600;
Imin=5*Q/3600;
%OCV Look-Up Table
V=[2.25 3.2 3.25 3.25 3.3 3.3 3.3 3.35 3.35 3.35 3.75];
SOC=[0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];

[t,y]=sim('PowerInputModel');
figure
hold on
plot(t,30*ones(length(t)))
plot(t,-actualpower.signals.values,'b')
axis([0 50 25 32])
xlabel('Time (s)')
ylabel('Power (Watt)')
legend('Actual Power','Demand Power')
box on
hold off